set echo off
Rem
Rem $Header: rdbms/demo/syncref_cst.sql /main/1 2012/01/26 19:01:42 sramakri Exp $
Rem
Rem syncref_cst.sql
Rem
Rem Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      syncref_cst.sql - Sync Refresh CAN_SYNCREF_TABLE wrappers
Rem
Rem    DESCRIPTION
Rem      This script defines two wrapper procedures called DO_CST and DO_CST_ARR 
Rem      on the dbms_syncref.can_syncref_table procedure; the latter procedure
Rem      requires the table called SYNCREF_TABLE be present in the schema. The
Rem      SYNCREF_TABLE is created by utlsrt.sql.
Rem      
Rem      Both DO_CST and DO_CST_ARR execute can_syncref_table and display results
Rem      on the screen in a convenient format. See the demo file syncref_run.sql
Rem      for examples of their usage. 
Rem
Rem      For each mv of the table the output from these procedures consist of
Rem      of a series of messages which looks like this:
Rem      ---------------------------------------
Rem      MV_NAME = <name of mv>
Rem      [sequence-number] <QSM-message-number> <messaege>
Rem       ....
Rem
Rem      The sequence-number starts with 1.
Rem 
Rem      For details on the QSM-message, including its cause and action, please 
Rem      refer to qsmus.msg. If the condition described in the message makes the mv 
Rem      ineligible for sync-refresh, the string ERROR! will between appended to the 
Rem      message. 
Rem
Rem
Rem    NOTES
Rem      Assumes the user is connected
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sramakri    01/15/12 - Sync Refresh demo script for cst
Rem    sramakri    01/15/12 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


CREATE OR REPLACE PROCEDURE do_cst(schema_name   IN VARCHAR2, 
                                   table_name    IN VARCHAR2, 
                                   in_stmt_id    IN VARCHAR2) 
IS
  cursor cur1 is select schema_name, table_name,
  mv_schema_name, mv_name, eligible, seq_num, msg_number, message
  from syncref_table 
  where statement_id = in_stmt_id
  order by mv_schema_name, mv_name, seq_num;
  errmsg varchar2(30);
BEGIN
   delete from syncref_table where statement_id = in_stmt_id;
   commit;

   dbms_sync_refresh.can_syncref_table(schema_name, table_name, in_stmt_id);

   for c1 in cur1 loop
     if c1.seq_num = 1 then
       dbms_output.put_line('---------------------------------------');
       dbms_output.put_line('MV_NAME = ' || c1.mv_name);
       dbms_output.put_line(' ');
     end if;

     if c1.eligible = 'N' then
       errmsg := ' ERROR! ';
     else
        errmsg := '';
     end if;

     dbms_output.put_line('[' || c1.seq_num || '] ' || c1.msg_number || 
                          ' ' || c1.message || ' ' || errmsg);
   end loop;

END do_cst;
/

CREATE OR REPLACE PROCEDURE do_cst_arr(schema_name   IN VARCHAR2, 
                                       table_name    IN VARCHAR2)
IS
  oa Sys.CanSyncRefArrayType := Sys.CanSyncRefArrayType();
  no_of_msgs NUMBER;
  i NUMBER;
  errmsg varchar2(30);
BEGIN

   dbms_sync_refresh.can_syncref_table(schema_name, table_name, oa);

   DBMS_OUTPUT.enable(32512);
   no_of_msgs := OA.count;
   FOR i IN 1..no_of_msgs
   LOOP
     if OA(i).seq_num = 1 then
       dbms_output.put_line('---------------------------------------');
       dbms_output.put_line('MV_NAME = ' || OA(i).mv_name);
       dbms_output.put_line(' ');
     end if;

     if OA(i).eligible = 'N' then
       errmsg := ' ERROR! ';
     else
        errmsg := '';
     end if;

     dbms_output.put_line('[' || OA(i).seq_num || '] ' || OA(i).msg_number || 
                          ' ' || OA(i).message || ' ' || errmsg);
   END LOOP;

END do_cst_arr;
/

set echo on
